#include <windows.h>

enum level_t
{
	easy = 4,
	medium = 3,
	hard = 2,
	crazy = 1,
	hardcore = 0
};

struct point_t
{
	short x;
	short y;
};

struct extraPet_t
{
	point_t	pos;
	bool	state;
	unsigned int counter;
	unsigned long lastTick;
};

extraPet_t extraPet = { (-1,-1), false };

typedef void (*randomPet_t)();
randomPet_t randomPet = (randomPet_t)0x004014CA;

typedef void (*printPet_t)();

typedef int (*checkCollisionSelf_t)(point_t * p);
checkCollisionSelf_t checkCollisionSelf = (checkCollisionSelf_t)0x004012BE;


typedef unsigned char (*checkCollisionPet_t)();
checkCollisionPet_t checkCollisionPet = (checkCollisionPet_t)0x00401323;

typedef void (*write_t)(short x, short y, char c);
write_t write = (write_t)0x004022C1;

point_t * petPos = (point_t*)0x0041902A;
point_t * headPos = (point_t*)0x00418080;

unsigned int * points = (unsigned int*)0x419030;
unsigned char * statePet = (unsigned char*)0x41902E;

level_t lvl = easy;

void printPetEx()
{
	((printPet_t)0x00412F86)();

	if ( extraPet.state )
	{
		write(extraPet.pos.x, extraPet.pos.y, 'O');
	}
}

void randomPetEx()
{
	randomPet();

	if ( extraPet.state == false )
	{
		if ( extraPet.counter == 5 )
		{
			do
			{
				extraPet.pos.x = rand() % 76 + 2;
				extraPet.pos.y = rand() % 18 + 2;
			} while ( checkCollisionSelf(&extraPet.pos) && extraPet.pos.x != (*petPos).x && extraPet.pos.y != (*petPos).y );

			extraPet.counter = 0;
			extraPet.lastTick = GetTickCount();
			extraPet.state = true;
		}
	}
	else
	{
		if ( GetTickCount() - extraPet.lastTick >= (3000 + lvl * 500)  )
		{
			write(extraPet.pos.x, extraPet.pos.y, ' ');
			extraPet.state = 0;
			extraPet.counter = 0;
		}
	}
}

unsigned char checkCollisionPetEx()
{
	unsigned char result = 0;
	if ( checkCollisionPet() )
	{
		extraPet.counter++;

		(*points)++;
		*statePet = 0;
		result = 1;
	}
	if ( extraPet.state )
	{
		if ( extraPet.pos.x == (*headPos).x && extraPet.pos.y == (*headPos).y )
		{
			result = 1;
			extraPet.state = false;
			extraPet.counter = 0;
			(*points) += 3;
		}
	}

	return result;
}

void Patch()
{
	*(unsigned int*)0x00412F5B = (unsigned int)lvl * 25;

	*(unsigned int*)(0x00401586+1) = (unsigned int)randomPetEx - (0x00401586 + 5);
	*(unsigned int*)(0x004015BD+1) = (unsigned int)checkCollisionPetEx - (0x004015BD + 5);



	*(unsigned int*)0x00412F6B = (unsigned int)printPetEx;
}

void Init()
{
	unsigned long oldProtect = 0;
	if ( VirtualProtect((void*)0x00401000, 0x12000, PAGE_EXECUTE_READWRITE, &oldProtect) )
	{
		char * title = "  :: Snake Ultimate v2.0";
		memcpy((void*)0x4160F8, title, 32);
		
		Patch();
	}
}

BOOL WINAPI DllMain( HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved )
{
	if ( fdwReason == DLL_PROCESS_ATTACH )
		Init();

	return TRUE;
}